package com.agilex.healthcare.veteranappointment.datalayer.patient;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.veteranappointment.datalayer.PersistenceObject;
import com.agilex.healthcare.veteranappointment.datalayer.Transformable;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = "PATIENT")
@XStreamAlias("Patient")
public class PatientPo extends PersistenceObject implements Transformable<Patient> {
	private static final long serialVersionUID = 2439300904557681903L;

	private String firstName;
	private String lastName;
	private String ssn;
	private Date dateOfBirth;
	private boolean lastApptTextMessagingAllowed;
	private String lastApptTextMessagingPhoneNumber;

	public PatientPo() {
	}
	
	public PatientPo(Patient dto) {
		setUserId(dto.getPatientIdentifier().getUniqueId());
		setFirstName(dto.getFirstName());
		setLastName(dto.getLastName());
		setSsn(dto.getSsn());
		DOBDate dobDate = dto.getDateOfBirth();
		setDateOfBirth(dobDate == null ? null : dobDate.getDate());
		setLastApptTextMessagingAllowed(dto.isTextMessagingAllowed());
		setLastApptTextMessagingPhoneNumber(dto.getTextMessagingPhoneNumber());
	}

	@Id
	@Column(name = "PATIENT_ID", nullable = false)
	public String getUserId() {
		return super.getUserId();
	}

	public void setUserId(String userId) {
		super.setUserId(userId);
	}

	@Column(name = "FIRST_NAME", nullable = false)
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	@Column(name = "LAST_NAME", nullable = false)
	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	

	@Column(name = "SSN", nullable = false, length = 20)
	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	@Column(name = "DATE_OF_BIRTH", nullable = false, length = 100)
	public Date getDateOfBirth() {
		return dateOfBirth;
	}

	public void setDateOfBirth(Date dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	@Column(name = "TEXT_MESSAGING_ALLOWED", nullable = false)
	public boolean isLastApptTextMessagingAllowed() {
		return lastApptTextMessagingAllowed;
	}

	public void setLastApptTextMessagingAllowed(boolean lastApptTextMessagingAllowed) {
		this.lastApptTextMessagingAllowed = lastApptTextMessagingAllowed;
	}

	@Column(name = "TEXT_MESSAGING_PHONE_NUMBER")
	public String getLastApptTextMessagingPhoneNumber() {
		return lastApptTextMessagingPhoneNumber;
	}

	public void setLastApptTextMessagingPhoneNumber(
			String lastApptTextMessagingPhoneNumber) {
		this.lastApptTextMessagingPhoneNumber = lastApptTextMessagingPhoneNumber;
	}

	@Override
	public Patient create() {
		Patient dto = new Patient();
		
		dto.setId(getUserId());
		dto.setFirstName(getFirstName());
		dto.setLastName(getLastName());
		dto.setSsn(getSsn());
		dto.setDateOfBirth(new DOBDate(getDateOfBirth()));
		dto.setTextMessagingAllowed(isLastApptTextMessagingAllowed());
		dto.setTextMessagingPhoneNumber(getLastApptTextMessagingPhoneNumber());
		
		return dto;
	}
}
